	function editarCtrl($scope, $location, $routeParams, $http, Elemento, lang, ElementoServ,TipoServ,$upload,$timeout,$filter) {
		init($scope,lang);

        var idElemento = $routeParams.elemento_id;

        $scope.elemento={};
        $scope.departamentoList = [];
        $scope.departamentoSeleccionadoID = {};
        $scope.provinciaList = [];
        $scope.provinciaListAux = [];
        $scope.provinciaSeleccionadoID = {};
        $scope.distritoList = [];
        $scope.distritoListAux = [];
        $scope.distritoSeleccionadoID = {};
        $scope.tipoElementoList = [];
        $scope.tipoElementoSeleccionadoID = {};
        $scope.subTipoElementoList = [];
        $scope.subTipoElementoListAux = [];
        $scope.subtipoElementoSeleccionadoID = {};
        $scope.campaniaList = [];
        $scope.campaniaSeleccionadoID = {};
        $scope.clienteList = [];
        $scope.clienteSeleccionadoID = {};

        $scope.radioContrato = "2";
        $scope.radioLicencia = "1";
        $scope.radioDNI = "1";
        $scope.radioDJ = "1";
        $scope.radioRP = "1";
        $scope.radioRecibo = "1";

        $scope.server = "server/handlerimagenelemento.php?";
        $scope.listaImagenes = [];

        $scope.tipoArchicoSeleccionado = null;

        $scope.tipoArchivo = [
            {archivoelemento_id:null,elemento_id:null,archivoelemento_tipo: '1', archivoelemento_estadodoc:$scope.radioContrato, archivoelemento_estado:1,archivoelemento_url: null, archivoelemento_fechavencimiento:null,descripcion: 'Contrato'},
            {archivoelemento_id:null,elemento_id:null,archivoelemento_tipo: '2', archivoelemento_estadodoc:$scope.radioLicencia, archivoelemento_estado:1,archivoelemento_url: null, archivoelemento_fechavencimiento:null,descripcion: 'Licencia'},
            {archivoelemento_id:null,elemento_id:null,archivoelemento_tipo: '3', archivoelemento_estadodoc:$scope.radioDNI, archivoelemento_estado:1,archivoelemento_url: null, archivoelemento_fechavencimiento:null,descripcion: 'DNI'},
            {archivoelemento_id:null,elemento_id:null,archivoelemento_tipo: '4', archivoelemento_estadodoc:$scope.radioDJ, archivoelemento_estado:1,archivoelemento_url: null, archivoelemento_fechavencimiento:null,descripcion: 'DD.JJ.'},
            {archivoelemento_id:null,elemento_id:null,archivoelemento_tipo: '5', archivoelemento_estadodoc:$scope.radioRP, archivoelemento_estado:1,archivoelemento_url: null, archivoelemento_fechavencimiento:null,descripcion: 'Reg. Propiedad'},
            {archivoelemento_id:null,elemento_id:null,archivoelemento_tipo: '6', archivoelemento_estadodoc:$scope.radioRecibo, archivoelemento_estado:1,archivoelemento_url: null, archivoelemento_fechavencimiento:null,descripcion: 'Recibo'},
        ];

        $scope.clienteDefault = {};
        $scope.clienteDefault.cliente_id = -1;
        $scope.clienteDefault.cliente_nombres = "Ninguno";
        $scope.clienteDefault.cliente_apellidos= "";

        $scope.cargarListaSubtipoElemento = cargarListaSubtipoElemento;
        $scope.tipoElemento = tipoElemento;
        $scope.obtenerObjElemento = obtenerObjElemento;
        $scope.cargarUbigeo = cargarUbigeo;
        $scope.cargarCampanias = cargarCampanias;
        $scope.mostrarProvinciaPorDepartamento = mostrarProvinciaPorDepartamento;
        $scope.mostrarDistritoPorProvincia = mostrarDistritoPorProvincia;
        $scope.mostrarSubtipoPorTipo = mostrarSubtipoPorTipo;
        $scope.imagenActual = imagenActual;
        $scope.asignarDatosElementoRecuperado = asignarDatosElementoRecuperado;
        $scope.subirArchivo = subirArchivo;
        $scope.abrirModalFecha = abrirModalFecha;
        $scope.asignarFecha = asignarFecha;
        $scope.descargar = descargar;
        $scope.cargarClientes = cargarClientes;

        function _init() {
            $scope.cargarUbigeo();
            $scope.tipoElemento();
        }

        _init();


        function obtenerObjElemento() {

            Elemento.get({elemento_id: idElemento},function(response){

                if (response.tipo == SUCCESS) {
                    $scope.elemento =response.datos;
                    $scope.listaImagenes =response.datos.listaImagenes;
                    $scope.archivosElemento =response.datos.archivosElemento;

                    $timeout(function() {
                        jQuery('.superbox').SuperBox();
                    });

                    $scope.asignarDatosElementoRecuperado();
                }
                else{
                    $location.path("/");
                    smallBoxErrors(["Ocurrio un error al cargar los datos"]);
                }
            });

        }

        function tipoElemento() {

            TipoServ.getAll().success(function(response) {
                if (response.tipo == SUCCESS) {
                    $scope.tipoElementoList=response.datos;
                    if($scope.tipoElementoList.length){
                        $scope.tipoElementoSeleccionadoID = $scope.tipoElementoList[0].tipo_id;
                        $scope.cargarListaSubtipoElemento();
                    }
                }
                else{
                    smallBoxErrors(["Ocurrio un error al cargar los datos"]);
                }
            });

        }

        function cargarListaSubtipoElemento() {

            $http.get("api/rest/subtipo/subtipo/all").success(function (response) {
                $scope.subTipoElementoListAux = response.datos;
                $scope.subtipoElementoSeleccionadoID = $scope.subTipoElementoListAux[0].subtipo_id;

                $scope.mostrarSubtipoPorTipo($scope.tipoElementoSeleccionadoID);

                $scope.cargarCampanias();
            });

        }

        function cargarCampanias() {

            $http.get("api/rest/campania/campania/all").success(function (response) {
                if (response.tipo == SUCCESS) {
                    $scope.campaniaList=response.datos;
                    if($scope.campaniaList.length){
                        $scope.campaniaSeleccionadoID = $scope.campaniaList[0].campania_id;
                    }

                    $scope.cargarClientes();
                }
                else{
                    smallBoxErrors(["Ocurrio un error al cargar los datos"]);
                }
            });
        }

        function cargarUbigeo() {

            $http.get('api/rest/pais/obtenerUbigeoPorPais').success(function (response){

                if (response.tipo == SUCCESS) {

                    $scope.departamentoList = response.datos.departamentoList;
                    $scope.departamentoSeleccionadoID = $scope.departamentoList[0].departamento_id;

                    $scope.provinciaListAux = response.datos.provinciaList;
                    $scope.distritoListAux = response.datos.distritoList;

                    $scope.mostrarProvinciaPorDepartamento($scope.departamentoSeleccionadoID);

                }

                if (response.tipo == ERROR) {
                    smallBoxErrors(response.mensajes);
                }

            });

        }

        function mostrarProvinciaPorDepartamento(departamento_id) {
            $scope.provinciaList.length = 0;

            angular.forEach($scope.provinciaListAux,function (provincia) {
                if(provincia.departamento_id == departamento_id ){
                    $scope.provinciaList.push(provincia);
                }
            })

            $scope.provinciaSeleccionadoID = $scope.provinciaList[0].provincia_id;

            $scope.mostrarDistritoPorProvincia($scope.provinciaSeleccionadoID);

        }

        function mostrarDistritoPorProvincia(provincia_id) {

            $scope.distritoList.length = 0;
            angular.forEach($scope.distritoListAux,function (distrito) {
                if(distrito.provincia_id == provincia_id ){
                    $scope.distritoList.push(distrito);
                }
            })

            $scope.distritoSeleccionadoID = $scope.distritoList[0].distrito_id;

        }

        function mostrarSubtipoPorTipo(tipo_id) {

            $scope.subTipoElementoList.length = 0;

            angular.forEach($scope.subTipoElementoListAux,function (subtipo) {
                if(subtipo.tipo_id == tipo_id ){
                    $scope.subTipoElementoList.push(subtipo);
                }
            })

            if($scope.subTipoElementoList.length){
                $scope.subtipoElementoSeleccionadoID = $scope.subTipoElementoList[0].subtipo_id;
            }

        }

        function imagenActual(img) {
            try {
                $scope.imagenModificar = angular.copy(img);
                if ($scope.imagenModificar.imgavancetrabajo_fechaimagen != null) {
                    $scope.imagenModificar.imgavancetrabajo_fechaimagen = $filter('date')((new Date($scope.imagenModificar.imgavancetrabajo_fechaimagen)), 'dd-MM-yyyy');
                }
            } catch (er) {
                $scope.imagenModificar = {};
            }
        }

        var myDropzone;
        $(document).ready(function() {
            $("#galeria").on("click", "a.btnDelete", function(e) {
                e.preventDefault();
                eliminarImg();
            });
            $("#galeria").on("click", "a.btnEdit", function(e) {
                e.preventDefault();
                $('#modificarImagen').modal('show');
            });
            try {

                Dropzone.options["mydropzone"] = false;
                myDropzone = new Dropzone("#mydropzone", {
                    paramName: 'archivo',
                    method: 'post',
                    maxFiles: 10,
                    url: $scope.server,
                    dictDefaultMessage: '<span class="font-xl"><i class="fa fa-caret-right red"></i> Arrastra tus archivos para subir</span><strong class="smaller-80 grey">(o haz click)</strong> <br /> \<i class="fa upload-icon fa-cloud-upload text-info fa-5x"></i>',
                    dictResponseError: 'Error mientras subÃ­a el archivo!',
                    previewTemplate: "<div class=\"dz-preview dz-file-preview\">\n  <div class=\"dz-details\">\n    <div class=\"dz-filename\"><span data-dz-name></span></div>\n    <div class=\"dz-size\" data-dz-size></div>\n    <img data-dz-thumbnail />\n  </div>\n  <div class=\"progress progress-small progress-striped active\"><div class=\"progress-bar progress-bar-success\" data-dz-uploadprogress></div></div>\n  <div class=\"dz-success-mark\"><span></span></div>\n  <div class=\"dz-error-mark\"><span></span></div>\n  <div class=\"dz-error-message\"><span data-dz-errormessage></span></div>\n</div>",
                    clickable: true,
                    maxFilesize: 10,
                    acceptedFiles: ".jpeg,.jpg,.png,.JPG,.PNG",
                    uploadMultiple: false,
                    addRemoveLinks: true,
                    dictRemoveFile: "Eliminar imagen",
                    dictCancelUpload: "Cancelar" +
                    "" +
                    "",
                    forceFallback: false,
                    init: function() {
                        // from the doc, quick debug
                        this.on("maxfilesexceeded", function(file) {
                            alert("El limite de archivos es 4");
                        });
                        this.on("complete", function(file) {
                            if (file.status == "success") {

                                try {

                                    var content = JSON.parse(file.xhr.response);

                                    $scope.imagenelemento = {};
                                    $scope.imagenelemento.elemento_id = $scope.elemento.elemento_id;
                                    $scope.imagenelemento.imagenelemento_url = content.path;
                                    $scope.imagenelemento.imagenelemento_estado = 1;
                                    $scope.imagenelemento.imagenelemento_nombre = content.name;

                                    $http.post("api/rest/imagenelemento/imagenelemento", angular.copy($scope.imagenelemento)).success(function(response) {
                                        if (response.tipo == 3) {
                                            smallBoxErrors(["Error al Registrar esta Imagen", "Intentelo Nuevamente"]);
                                        } else {
                                            $scope.listaImagenes.push($scope.imagenelemento);

                                            _init();

                                        }
                                    });


                                } catch (e) {
                                    smallBoxErrors(["Se produjo un error al subir tu imagen."]);
                                }
                            }
                        });
                        this.on("removedfile",function (file) {
                            angular.forEach($scope.listaImagenes,function (imagen,index) {
                                if(imagen.imagenelemento_nombre == file.name){
                                    $scope.listaImagenes.splice(index,1)
                                }
                            })
                        })
                    }
                });
            } catch (e) {
                alert('Esta opción no es soportada en navegadores antiguos. Descarge una version mas reciente para usar esta funcionalidad' + e);
            }
        });

        function eliminarImg() {

            $.SmartMessageBox({
                title: "¿Desea Eliminar esta Imágen?",
                content: "",
                buttons: '[Cancelar][Si]'
            }, function(ButtonPressed) {
                if (ButtonPressed === 'Si') {
                    $http.delete("api/rest/imagenelemento/imagenelemento/" + $scope.imagenModificar.imagenelemento_id).success(function(response) {
                        if (response.tipo == 3) {

                            smallBoxErrors(["Error al Eliminar esta Imagen. Intentelo Nuevamente"]);

                        } else {

                            smallBoxSuccess(["Imagen Eliminada Correctamente"]);

                            angular.forEach($scope.listaImagenes, function(item,index) {
                                if (item.imagenelemento_id == $scope.imagenModificar.imagenelemento_id) {
                                    $scope.listaImagenes.splice(index, 1);

                                }
                            });
                        }
                    });
                }
            });
        }

        function asignarDatosElementoRecuperado() {

            $scope.campaniaSeleccionadoID = $scope.elemento.campania_id;
            if($scope.elemento.cliente_id*1>0){
                $scope.clienteSeleccionadoID = $scope.elemento.cliente_id;
            }

            angular.forEach($scope.subTipoElementoListAux,function (subtipo) {
                if(subtipo.subtipo_id == $scope.elemento.subtipo_id){
                    $scope.tipoElementoSeleccionadoID =  subtipo.tipo_id;
                    $scope.mostrarSubtipoPorTipo($scope.tipoElementoSeleccionadoID);
                    $scope.subtipoElementoSeleccionadoID = $scope.elemento.subtipo_id;
                }
            })

            angular.forEach($scope.distritoListAux,function (distrito) {
                if(distrito.distrito_id == $scope.elemento.distrito_id){
                    $scope.provinciaSeleccionadoID =  distrito.provincia_id;
                    $scope.mostrarDistritoPorProvincia($scope.provinciaSeleccionadoID);
                    $scope.distritoSeleccionadoID =  distrito.distrito_id;

                    angular.forEach($scope.provinciaListAux,function (provincia) {
                        if(provincia.provincia_id == $scope.provinciaSeleccionadoID){
                            $scope.departamentoSeleccionadoID = provincia.departamento_id;
                            $scope.mostrarProvinciaPorDepartamento($scope.departamentoSeleccionadoID);
                            $scope.provinciaSeleccionadoID = provincia.provincia_id;
                        }
                    })
                }
            })

            // Almaceno los datos de los radio buttons
            $scope.radioContrato = $scope.archivosElemento[0].archivoelemento_estadodoc;
            $scope.radioLicencia = $scope.archivosElemento[1].archivoelemento_estadodoc;
            $scope.radioDNI = $scope.archivosElemento[2].archivoelemento_estadodoc;
            $scope.radioDJ = $scope.archivosElemento[3].archivoelemento_estadodoc;
            $scope.radioRP = $scope.archivosElemento[4].archivoelemento_estadodoc;
            $scope.radioRecibo = $scope.archivosElemento[5].archivoelemento_estadodoc;

            $scope.tipoArchivo[0].archivoelemento_estadodoc=$scope.radioContrato;
            $scope.tipoArchivo[1].archivoelemento_estadodoc=$scope.radioLicencia;
            $scope.tipoArchivo[2].archivoelemento_estadodoc=$scope.radioDNI;
            $scope.tipoArchivo[3].archivoelemento_estadodoc=$scope.radioDJ;
            $scope.tipoArchivo[4].archivoelemento_estadodoc=$scope.radioRP;
            $scope.tipoArchivo[5].archivoelemento_estadodoc=$scope.radioRecibo;

            $scope.tipoArchivo[0].archivoelemento_id=$scope.archivosElemento[0].archivoelemento_id;
            $scope.tipoArchivo[1].archivoelemento_id=$scope.archivosElemento[1].archivoelemento_id;
            $scope.tipoArchivo[2].archivoelemento_id=$scope.archivosElemento[2].archivoelemento_id;
            $scope.tipoArchivo[3].archivoelemento_id=$scope.archivosElemento[3].archivoelemento_id;
            $scope.tipoArchivo[4].archivoelemento_id=$scope.archivosElemento[4].archivoelemento_id;
            $scope.tipoArchivo[5].archivoelemento_id=$scope.archivosElemento[5].archivoelemento_id;

            $scope.tipoArchivo[0].archivoelemento_id=$scope.archivosElemento[0].archivoelemento_id;
            $scope.tipoArchivo[1].archivoelemento_id=$scope.archivosElemento[1].archivoelemento_id;
            $scope.tipoArchivo[2].archivoelemento_id=$scope.archivosElemento[2].archivoelemento_id;
            $scope.tipoArchivo[3].archivoelemento_id=$scope.archivosElemento[3].archivoelemento_id;
            $scope.tipoArchivo[4].archivoelemento_id=$scope.archivosElemento[4].archivoelemento_id;
            $scope.tipoArchivo[5].archivoelemento_id=$scope.archivosElemento[5].archivoelemento_id;

            $scope.tipoArchivo[0].archivoelemento_url=$scope.archivosElemento[0].archivoelemento_url;
            $scope.tipoArchivo[1].archivoelemento_url=$scope.archivosElemento[1].archivoelemento_url;
            $scope.tipoArchivo[2].archivoelemento_url=$scope.archivosElemento[2].archivoelemento_url;
            $scope.tipoArchivo[3].archivoelemento_url=$scope.archivosElemento[3].archivoelemento_url;
            $scope.tipoArchivo[4].archivoelemento_url=$scope.archivosElemento[4].archivoelemento_url;
            $scope.tipoArchivo[5].archivoelemento_url=$scope.archivosElemento[5].archivoelemento_url;

            $scope.tipoArchivo[0].archivoelemento_fechavencimiento=$scope.archivosElemento[0].archivoelemento_fechavencimiento;
            $scope.tipoArchivo[1].archivoelemento_fechavencimiento=$scope.archivosElemento[1].archivoelemento_fechavencimiento;
            $scope.tipoArchivo[2].archivoelemento_fechavencimiento=$scope.archivosElemento[2].archivoelemento_fechavencimiento;
            $scope.tipoArchivo[3].archivoelemento_fechavencimiento=$scope.archivosElemento[3].archivoelemento_fechavencimiento;
            $scope.tipoArchivo[4].archivoelemento_fechavencimiento=$scope.archivosElemento[4].archivoelemento_fechavencimiento;
            $scope.tipoArchivo[5].archivoelemento_fechavencimiento=$scope.archivosElemento[5].archivoelemento_fechavencimiento;

            $scope.tipoArchivo[0].elemento_id=$scope.archivosElemento[0].elemento_id;
            $scope.tipoArchivo[1].elemento_id=$scope.archivosElemento[1].elemento_id;
            $scope.tipoArchivo[2].elemento_id=$scope.archivosElemento[2].elemento_id;
            $scope.tipoArchivo[3].elemento_id=$scope.archivosElemento[3].elemento_id;
            $scope.tipoArchivo[4].elemento_id=$scope.archivosElemento[4].elemento_id;
            $scope.tipoArchivo[5].elemento_id=$scope.archivosElemento[5].elemento_id;

            console.log("$scope.tipoArchivo",$scope.tipoArchivo);
        }

        $scope.editar = function() {
			var btn = jQuery("#btnEditar");
			btn.button("loading");

            //Recupero datos del elemento
            $scope.elemento.campania_id = $scope.campaniaSeleccionadoID;
            $scope.elemento.distrito_id = $scope.distritoSeleccionadoID;
            $scope.elemento.subtipo_id = $scope.subtipoElementoSeleccionadoID;
            $scope.elemento.cliente_id = $scope.clienteSeleccionadoID;
            $scope.elemento.listaImagenes = $scope.listaImagenes;

            $scope.tipoArchivo[0].archivoelemento_estadodoc=$scope.radioContrato;
            $scope.tipoArchivo[1].archivoelemento_estadodoc=$scope.radioLicencia;
            $scope.tipoArchivo[2].archivoelemento_estadodoc=$scope.radioDNI;
            $scope.tipoArchivo[3].archivoelemento_estadodoc=$scope.radioDJ;
            $scope.tipoArchivo[4].archivoelemento_estadodoc=$scope.radioRP;
            $scope.tipoArchivo[5].archivoelemento_estadodoc=$scope.radioRecibo;

            $scope.elemento.listaArchivos = $scope.tipoArchivo;

			var elemento = new Elemento($scope.elemento);
			elemento.$update({elemento_id: $scope.elemento.elemento_id},function(response){
				btn.button("reset");
				if (response.tipo == SUCCESS) {
					smallBoxSuccess(response.mensajes);
					window.history.back();
				}
				else if (response.tipo == ERROR) {
					smallBoxErrors(response.mensajes);
				}
				else{
					smallBoxErrors(["Ocurrio un error"]);
				}
			},function(data){});
		};

        $scope.objImagen = {};
        $scope.objImagen.documentos=[];

        function subirArchivo (tipoArchivo,estadoArchivo) {

            for (var i = 0; i < $scope.objImagen.documentos.length; i++) {
                var file = $scope.objImagen.documentos[i];

                var btn = jQuery("#btnSubirContrato");
                btn.button("loading");

                $scope.upload = $upload.upload({
                    url: 'server/handlerImportacionDocumento.php',
                    data: {myObj: $scope.myModelObj},
                    file: file,
                    fileFormDataName: "archivo",
                }).progress(function (evt) {

                }).success(function (data, status, headers, config) {

                    btn.button("reset");

                    $scope.tipoArchivo[tipoArchivo-1].archivoelemento_url = data.path;

                    //console.log("$scope.tipoArchivo",$scope.tipoArchivo);
                });
            }
        }

        function abrirModalFecha(tipoArchivo){

            $scope.tipoArchicoSeleccionado = tipoArchivo;
            $scope.fechaVencimiento = $scope.tipoArchivo[$scope.tipoArchicoSeleccionado-1].archivoelemento_fechavencimiento;

            $("#modalFecha").modal({backdrop:'static'});
        }

        function asignarFecha(){

            $scope.tipoArchivo[$scope.tipoArchicoSeleccionado-1].archivoelemento_fechavencimiento = $filter('date')($scope.fechaVencimiento, 'yyyy-MM-dd');
            $scope.fechaVencimiento = null;
            $("#modalFecha").modal('hide');
        }

        function descargar(tipo) {

            var url = $scope.archivosElemento[tipo-1].archivoelemento_url;

            if(!url ||url == "" || url == null){
                smallBoxErrors(['Error, debes selecionar un elemento para poder realizar la descarga ']);
                return;
            }

            //window.location.href = url;
            window.open(url);
        }

        function cargarClientes() {

            $http.get("api/rest/cliente/cliente/all").success(function (response) {
                if (response.tipo == SUCCESS) {
                    $scope.clienteList=response.datos;
                    if($scope.clienteList.length){
                        $scope.clienteList.push($scope.clienteDefault);
                        $scope.clienteSeleccionadoID = $scope.clienteList[$scope.clienteList.length-1].cliente_id;
                    }

                    // Se carga el elemento
                    if(idElemento !== undefined){
                        $scope.obtenerObjElemento();
                    }else{
                        $scope.elemento.subtipo_id = $scope.subTipoElementoList[0].subtipo_id;
                    }

                }
                else{
                    smallBoxErrors(["Ocurrio un error al cargar los datos"]);
                }
            });
        }

	}