	function indexCtrl($scope, $location, $routeParams, $http, Elemento, lang, ElementoServ, TipoServ, SubtipoServ ){

		init($scope,lang);

        var pagina = $routeParams.pagina;
        if (!(parseInt(pagina)>0))
            pagina = "1";
        var registros = "10";
        $scope.departamentoList = [];
        $scope.departamentoSeleccionadoID = {};
        $scope.provinciaList = [];
        $scope.provinciaListAux = [];
        $scope.provinciaSeleccionadoID = {};
        $scope.distritoList = [];
        $scope.distritoListAux = [];
        $scope.distritoSeleccionadoID = {};
        $scope.tipoElementoList = [];
        $scope.tipoElementoSeleccionadoID = {};
        $scope.subTipoElementoList = [];
        $scope.subTipoElementoListAux = [];
        $scope.subtipoElementoSeleccionadoID = {};
        $scope.elementoFiltro = "";
        $scope.limiteFiltro = 10;
        $scope.verVencidos = 0;
        $scope.verTodos = "1";

		$scope.eliminar = eliminar;
		$scope.cargarUbigeo = cargarUbigeo;
		$scope.cambiarPagina = cambiarPagina;
		$scope.tipoElemento = tipoElemento;
		$scope.subTipoElemento = subTipoElemento;
		$scope.cargarElementos = cargarElementos;
		$scope.mostrarProvinciaPorDepartamento = mostrarProvinciaPorDepartamento;
		$scope.mostrarDistritoPorProvincia = mostrarDistritoPorProvincia;
		$scope.mostrarSubtipoPorTipo = mostrarSubtipoPorTipo;

		function _init() {
            $scope.cargarUbigeo();
        }

        _init();

		function cambiarPagina() {
			$location.path("/" + $scope.pagina);
		};

		function eliminar(id) {
			$.SmartMessageBox({
				title : "Confirmación",
				content : "¿Esta seguro que desea eliminar este registro?",
				buttons : '[No][Yes]'
			}, function(ButtonPressed) {
				if (ButtonPressed === "Yes") {
					var btn = jQuery("#btnEliminar"+id);
					btn.button("loading");
					Elemento.eliminar({elemento_id: id}, function(response) {
						btn.button("reset");
						if (response.tipo == SUCCESS) {
							bigBoxSuccess(response.mensajes);
                            _init();
						}
						else if (response.tipo == ERROR) {
							bigBoxErrors(response.mensajes);
						}
						else{
							bigBoxErrors(["Ocurrio un error desconocido"]);
						}
					});
				}
			});
		};

		function cargarUbigeo() {

            $http.get('api/rest/pais/obtenerUbigeoPorPais').success(function (response){

                if (response.tipo == SUCCESS) {

                    $scope.departamentoList = response.datos.departamentoList;
                    $scope.departamentoSeleccionadoID = $scope.departamentoList[0].departamento_id;

                    $scope.provinciaListAux = response.datos.provinciaList;
                    $scope.distritoListAux = response.datos.distritoList;

                    $scope.mostrarProvinciaPorDepartamento($scope.departamentoSeleccionadoID);

                    $scope.tipoElemento();
                }

                if (response.tipo == ERROR) {
                    parseErrors(response.mensajes);
                }

            });

        }

        function cargarElementos() {

		    var distrito_id = $scope.distritoSeleccionadoID;
		    if($scope.verTodos == '1'){
                distrito_id = "-1";
            }
            ElementoServ.getPage(distrito_id,$scope.subtipoElementoSeleccionadoID,$scope.verVencidos).success(function(response) {

                if (response.tipo == SUCCESS) {
                    $scope.elementoList=response.datos.elementoList;
                    $scope.registros = registros;
                    $scope.pagina = pagina;
                    $scope.totalItems = response.datos.elementoCount;
                }
                else{
                    bigBoxErrors(["Ocurrio un error al cargar los datos"]);
                }
            });

        }

        function tipoElemento() {

            TipoServ.getAll().success(function(response) {
                if (response.tipo == SUCCESS) {
                    $scope.tipoElementoList=response.datos;

                    if($scope.tipoElementoList.length){
                        $scope.tipoElementoSeleccionadoID = $scope.tipoElementoList[0].tipo_id;
                        $scope.subTipoElemento();
                    }


                }
                else{
                    bigBoxErrors(["Ocurrio un error al cargar los datos"]);
                }
            });

        }

        function subTipoElemento() {

            SubtipoServ.getAll().success(function(response) {
                if (response.tipo == SUCCESS) {
                    $scope.subTipoElementoListAux=response.datos;

                    $scope.mostrarSubtipoPorTipo($scope.tipoElementoSeleccionadoID);

                    $scope.cargarElementos();
                }
                else{
                    bigBoxErrors(["Ocurrio un error al cargar los datos"]);
                }
            });

        }

        function mostrarProvinciaPorDepartamento(departamento_id) {
		    $scope.provinciaList.length = 0;

		    angular.forEach($scope.provinciaListAux,function (provincia) {
                if(provincia.departamento_id == departamento_id ){
                    $scope.provinciaList.push(provincia);
                }
            })

            $scope.provinciaSeleccionadoID = $scope.provinciaList[0].provincia_id;

		    $scope.mostrarDistritoPorProvincia($scope.provinciaSeleccionadoID);

        }

        function mostrarDistritoPorProvincia(provincia_id) {

		    $scope.distritoList.length = 0;
		    angular.forEach($scope.distritoListAux,function (distrito) {
                if(distrito.provincia_id == provincia_id ){
                    $scope.distritoList.push(distrito);
                }
            })

            $scope.distritoSeleccionadoID = $scope.distritoList[0].distrito_id;

        }

        function mostrarSubtipoPorTipo(tipo_id) {

            $scope.subTipoElementoList.length = 0;

            angular.forEach($scope.subTipoElementoListAux,function (subtipo) {
                if(subtipo.tipo_id == tipo_id ){
                    $scope.subTipoElementoList.push(subtipo);
                }
            })

            if($scope.subTipoElementoList.length){
                $scope.subtipoElementoSeleccionadoID = $scope.subTipoElementoList[0].subtipo_id;
            }

        }


	
		
		
	}