	function registrarCtrl($scope, $location, $routeParams, $http, Elemento, lang, ElementoServ,TipoServ,$upload,$filter) {
		init($scope,lang);

        $scope.elemento={};
        $scope.elemento.elemento_estado = "1";

        $scope.departamentoList = [];
        $scope.departamentoSeleccionadoID = {};
        $scope.provinciaList = [];
        $scope.provinciaListAux = [];
        $scope.provinciaSeleccionadoID = {};
        $scope.distritoList = [];
        $scope.distritoListAux = [];
        $scope.distritoSeleccionadoID = {};
        $scope.tipoElementoList = [];
        $scope.tipoElementoSeleccionadoID = {};
        $scope.subTipoElementoList = [];
        $scope.subTipoElementoListAux = [];
        $scope.subtipoElementoSeleccionadoID = {};
        $scope.campaniaList = [];
        $scope.clienteList = [];
        $scope.clienteSeleccionadoID = {};
        $scope.campaniaSeleccionadoID = {};
        $scope.radioContrato = "3";
        $scope.radioLicencia = "3";
        $scope.radioDNI = "3";
        $scope.radioDJ = "3";
        $scope.radioRP = "3";
        $scope.radioRecibo = "3";

        $scope.server = "server/handlerimagenelemento.php?";
        $scope.listaImagenes = [];

        $scope.tipoArchicoSeleccionado = null;

        $scope.tipoArchivo = [
            {archivoelemento_tipo: '1', archivoelemento_estadodoc:$scope.radioContrato, archivoelemento_estado:1,archivoelemento_url: null, archivoelemento_fechavencimiento:null,descripcion: 'Contrato'},
            {archivoelemento_tipo: '2', archivoelemento_estadodoc:$scope.radioLicencia, archivoelemento_estado:1,archivoelemento_url: null, archivoelemento_fechavencimiento:null,descripcion: 'Licencia'},
            {archivoelemento_tipo: '3', archivoelemento_estadodoc:$scope.radioDNI, archivoelemento_estado:1,archivoelemento_url: null, archivoelemento_fechavencimiento:null,descripcion: 'DNI'},
            {archivoelemento_tipo: '4', archivoelemento_estadodoc:$scope.radioDJ, archivoelemento_estado:1,archivoelemento_url: null, archivoelemento_fechavencimiento:null,descripcion: 'DD.JJ.'},
            {archivoelemento_tipo: '5', archivoelemento_estadodoc:$scope.radioRP, archivoelemento_estado:1,archivoelemento_url: null, archivoelemento_fechavencimiento:null,descripcion: 'Reg. Propiedad'},
            {archivoelemento_tipo: '6', archivoelemento_estadodoc:$scope.radioRecibo, archivoelemento_estado:1,archivoelemento_url: null, archivoelemento_fechavencimiento:null,descripcion: 'Recibo'},
        ];

        $scope.clienteDefault = {};
        $scope.clienteDefault.cliente_id = -1;
        $scope.clienteDefault.cliente_nombres = "Ninguno";
        $scope.clienteDefault.cliente_apellidos= "";

        $scope.cargarListaSubtipoElemento = cargarListaSubtipoElemento;
        $scope.registrarElemento = registrarElemento;
        $scope.cargarUbigeo = cargarUbigeo;
        $scope.tipoElemento = tipoElemento;
        $scope.cargarCampanias = cargarCampanias;
        $scope.mostrarProvinciaPorDepartamento = mostrarProvinciaPorDepartamento;
        $scope.mostrarDistritoPorProvincia = mostrarDistritoPorProvincia;
        $scope.mostrarSubtipoPorTipo = mostrarSubtipoPorTipo;
        $scope.subirArchivo = subirArchivo;
        $scope.abrirModalFecha = abrirModalFecha;
        $scope.asignarFecha = asignarFecha;
        $scope.cargarClientes = cargarClientes;


        function _init() {
            $scope.tipoElemento();
            $scope.cargarUbigeo();
            $scope.cargarCampanias();
            $scope.cargarClientes();
        }

        _init();

        function registrarElemento() {
			var btn = jQuery("#btnRegistrar");
			btn.button("loading");

			//Recupero datos del elemento
            $scope.elemento.campania_id = $scope.campaniaSeleccionadoID;
            $scope.elemento.distrito_id = $scope.distritoSeleccionadoID;
            $scope.elemento.subtipo_id = $scope.subtipoElementoSeleccionadoID;
            $scope.elemento.cliente_id = $scope.clienteSeleccionadoID;
            $scope.elemento.listaImagenes = $scope.listaImagenes;

            $scope.tipoArchivo[0].archivoelemento_estadodoc=$scope.radioContrato;
            $scope.tipoArchivo[1].archivoelemento_estadodoc=$scope.radioLicencia;
            $scope.tipoArchivo[2].archivoelemento_estadodoc=$scope.radioDNI;
            $scope.tipoArchivo[3].archivoelemento_estadodoc=$scope.radioDJ;
            $scope.tipoArchivo[4].archivoelemento_estadodoc=$scope.radioRP;
            $scope.tipoArchivo[5].archivoelemento_estadodoc=$scope.radioRecibo;

            $scope.elemento.listaArchivos = $scope.tipoArchivo;

			var elemento = new Elemento($scope.elemento);
			elemento.$save({},function(response){
				btn.button("reset");
				if (response.tipo == SUCCESS) {
                    $scope.elemento.elemento_id = response.datos;
					smallBoxSuccess(response.mensajes);
                    window.history.back();
				}
				else if (response.tipo == ERROR) {
					smallBoxErrors(response.mensajes);
				}
				else{
					smallBoxErrors(response.mensajes);
				}
			},function(data){});
		};

        function cargarUbigeo() {

            $http.get('api/rest/pais/obtenerUbigeoPorPais').success(function (response){

                if (response.tipo == SUCCESS) {

                    $scope.departamentoList = response.datos.departamentoList;
                    $scope.departamentoSeleccionadoID = $scope.departamentoList[0].departamento_id;

                    $scope.provinciaListAux = response.datos.provinciaList;
                    $scope.distritoListAux = response.datos.distritoList;

                    $scope.mostrarProvinciaPorDepartamento($scope.departamentoSeleccionadoID);

                }

                if (response.tipo == ERROR) {
                    smallBoxErrors(response.mensajes);
                }

            });

        }

        function tipoElemento() {

            TipoServ.getAll().success(function(response) {
                if (response.tipo == SUCCESS) {
                    $scope.tipoElementoList=response.datos;
                    if($scope.tipoElementoList.length){
                        $scope.tipoElementoSeleccionadoID = $scope.tipoElementoList[0].tipo_id;
                        $scope.cargarListaSubtipoElemento();
                    }
                }
                else{
                    smallBoxErrors(["Ocurrio un error al cargar los datos"]);
                }
            });

        }

        function cargarListaSubtipoElemento() {

            $http.get("api/rest/subtipo/subtipo/all").success(function (response) {
                $scope.subTipoElementoListAux = response.datos;
                $scope.subtipoElementoSeleccionadoID = $scope.subTipoElementoListAux[0].subtipo_id;

                $scope.mostrarSubtipoPorTipo($scope.tipoElementoSeleccionadoID);

                $scope.cargarCampanias();
            });

        }

        function cargarCampanias() {

            $http.get("api/rest/campania/campania/all").success(function (response) {
                if (response.tipo == SUCCESS) {
                    $scope.campaniaList=response.datos;
                    if($scope.campaniaList.length){
                        $scope.campaniaSeleccionadoID = $scope.campaniaList[0].campania_id;
                    }
                }
                else{
                    smallBoxErrors(["Ocurrio un error al cargar los datos"]);
                }
            });
        }

        function mostrarProvinciaPorDepartamento(departamento_id) {
            $scope.provinciaList.length = 0;

            angular.forEach($scope.provinciaListAux,function (provincia) {
                if(provincia.departamento_id == departamento_id ){
                    $scope.provinciaList.push(provincia);
                }
            })

            $scope.provinciaSeleccionadoID = $scope.provinciaList[0].provincia_id;

            $scope.mostrarDistritoPorProvincia($scope.provinciaSeleccionadoID);

        }

        function mostrarDistritoPorProvincia(provincia_id) {

            $scope.distritoList.length = 0;
            angular.forEach($scope.distritoListAux,function (distrito) {
                if(distrito.provincia_id == provincia_id ){
                    $scope.distritoList.push(distrito);
                }
            })

            $scope.distritoSeleccionadoID = $scope.distritoList[0].distrito_id;

        }

        function mostrarSubtipoPorTipo(tipo_id) {

            $scope.subTipoElementoList.length = 0;

            angular.forEach($scope.subTipoElementoListAux,function (subtipo) {
                if(subtipo.tipo_id == tipo_id ){
                    $scope.subTipoElementoList.push(subtipo);
                }
            })

            if($scope.subTipoElementoList.length){
                $scope.subtipoElementoSeleccionadoID = $scope.subTipoElementoList[0].subtipo_id;
            }

        }

        $scope.objImagen = {};
        $scope.objImagen.documentos=[];

        function subirArchivo (tipoArchivo,estadoArchivo) {

            for (var i = 0; i < $scope.objImagen.documentos.length; i++) {
                var file = $scope.objImagen.documentos[i];

                var btn = jQuery("#btnSubirContrato");
                btn.button("loading");

                $scope.upload = $upload.upload({
                    url: 'server/handlerImportacionDocumento.php',
                    data: {myObj: $scope.myModelObj},
                    file: file,
                    fileFormDataName: "archivo",
                }).progress(function (evt) {

                }).success(function (data, status, headers, config) {

                    btn.button("reset");

                    $scope.tipoArchivo[tipoArchivo-1].archivoelemento_url = data.path;

                });
            }
        }

        var myDropzone;
        $(document).ready(function() {
            $("#galeria").on("click", "a.btnDelete", function(e) {
                e.preventDefault();
                eliminarImg();
            });
            $("#galeria").on("click", "a.btnEdit", function(e) {
                e.preventDefault();
                $('#modificarImagen').modal('show');
            });
            try {

                Dropzone.options["mydropzone"] = false;
                myDropzone = new Dropzone("#mydropzone", {
                    paramName: 'archivo',
                    method: 'post',
                    maxFiles: 10,
                    url: $scope.server,
                    dictDefaultMessage: '<span class="font-xl"><i class="fa fa-caret-right red"></i> Arrastra tus archivos para subir</span><strong class="smaller-80 grey">(o haz click)</strong> <br /> \<i class="fa upload-icon fa-cloud-upload text-info fa-5x"></i>',
                    dictResponseError: 'Error mientras subÃ­a el archivo!',
                    previewTemplate: "<div class=\"dz-preview dz-file-preview\">\n  <div class=\"dz-details\">\n    <div class=\"dz-filename\"><span data-dz-name></span></div>\n    <div class=\"dz-size\" data-dz-size></div>\n    <img data-dz-thumbnail />\n  </div>\n  <div class=\"progress progress-small progress-striped active\"><div class=\"progress-bar progress-bar-success\" data-dz-uploadprogress></div></div>\n  <div class=\"dz-success-mark\"><span></span></div>\n  <div class=\"dz-error-mark\"><span></span></div>\n  <div class=\"dz-error-message\"><span data-dz-errormessage></span></div>\n</div>",
                    clickable: true,
                    maxFilesize: 10,
                    acceptedFiles: ".jpeg,.jpg,.png,.JPG,.PNG",
                    uploadMultiple: false,
                    addRemoveLinks: true,
                    dictRemoveFile: "Eliminar imagen",
                    dictCancelUpload: "Cancelar" +
                    "" +
                    "",
                    forceFallback: false,
                    init: function() {
                        // from the doc, quick debug
                        this.on("maxfilesexceeded", function(file) {
                            alert("El limite de archivos es 4");
                        });
                        this.on("complete", function(file) {
                            if (file.status == "success") {

                                try {

                                    var content = JSON.parse(file.xhr.response);

                                    $scope.imagenelemento = {};
                                    $scope.imagenelemento.elemento_id = null;
                                    $scope.imagenelemento.imagenelemento_url = content.path;
                                    $scope.imagenelemento.imagenelemento_estado = 1;
                                    $scope.imagenelemento.imagenelemento_nombre = content.name;

                                    $scope.listaImagenes.push($scope.imagenelemento);


                                } catch (e) {
                                    smallBoxErrors(["Se produjo un error al subir tu imagen."]);
                                }
                            }
                        });
                        this.on("removedfile",function (file) {
                            angular.forEach($scope.listaImagenes,function (imagen,index) {
                                if(imagen.imagenelemento_nombre == file.name){
                                    $scope.listaImagenes.splice(index,1)
                                }
                            })
                        })
                    }
                });
            } catch (e) {
                alert('Esta opción no es soportada en navegadores antiguos. Descarge una version mas reciente para usar esta funcionalidad' + e);
            }
        });

        function eliminarImg() {
            if ($scope.imagenModificar.imgembarque_id == "0") return;
            $.SmartMessageBox({
                title: "¿Desea Eliminar esta Imágen?",
                content: "",
                buttons: '[Cancelar][Si]'
            }, function(ButtonPressed) {
                if (ButtonPressed === 'Si') {
                    $http.delete("api/rest/imgembarque/imgembarque/" + $scope.imagenModificar.imgembarque_id).success(function(response) {
                        if (response.tipo == 3) {
                            smallBoxErrors(["Error al Eliminar esta Imagen. Intentelo Nuevamente"]);
                            return;
                        } else {
                            mostrarMensaje("Imagen Eliminada", "Imagen Eliminada Correctamente");
                            var i = 0;
                            angular.forEach($scope.listaImagenes, function(item) {
                                if (item.imgembarque_id == $scope.imagenModificar.imgembarque_id) {
                                    $scope.listaImagenes.splice(i, 1);
                                    return;
                                } else i = i + 1;
                            });
                        }
                    });
                }
            });
        }

        function abrirModalFecha(tipoArchivo){

            $scope.tipoArchicoSeleccionado = tipoArchivo;
            $scope.fechaVencimiento = $scope.tipoArchivo[$scope.tipoArchicoSeleccionado-1].archivoelemento_fechavencimiento;

            $("#modalFecha").modal({backdrop:'static'});
        }

        function asignarFecha(){

            $scope.tipoArchivo[$scope.tipoArchicoSeleccionado-1].archivoelemento_fechavencimiento = $filter('date')($scope.fechaVencimiento, 'yyyy-MM-dd');;
            $scope.fechaVencimiento = null;
            $("#modalFecha").modal('hide');
        }

        function cargarClientes() {

            $http.get("api/rest/cliente/cliente/all").success(function (response) {
                if (response.tipo == SUCCESS) {
                    $scope.clienteList=response.datos;
                    if($scope.clienteList.length){
                        $scope.clienteList.push($scope.clienteDefault);
                        $scope.clienteSeleccionadoID = $scope.clienteList[$scope.clienteList.length-1].cliente_id;
                    }
                }
                else{
                    smallBoxErrors(["Ocurrio un error al cargar los datos"]);
                }
            });
        }


    }