<?php
/**
 * SCRIPT TEMPORAL PARA VER ERROR ESPECÍFICO
 * 
 * INSTRUCCIONES:
 * 1. Subir a: /publicidadpaneles/ver_error_especifico.php
 * 2. Acceder: http://sistema.dardocomunicaciones.com/publicidadpaneles/ver_error_especifico.php
 * 3. Copiar el mensaje de error completo
 * 4. ELIMINAR este archivo después
 */

error_reporting(E_ALL);
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);

echo '<h1>Test de Carga del Sistema</h1>';
echo '<hr>';

// Test 1: PHP Version
echo '<h2>1. Versión PHP</h2>';
echo 'PHP: ' . phpversion() . '<br>';
echo '<hr>';

// Test 2: Extensión GD
echo '<h2>2. Extensión GD</h2>';
if (extension_loaded('gd')) {
    echo '✓ GD: Habilitada<br>';
    echo 'imagecreatefromjpeg: ' . (function_exists('imagecreatefromjpeg') ? 'SÍ' : 'NO') . '<br>';
} else {
    echo '✗ GD: NO habilitada<br>';
}
echo '<hr>';

// Test 3: Definir PATH
echo '<h2>3. Definir PATH</h2>';
define("PATH", "api/");
echo 'PATH definido: ' . PATH . '<br>';
echo '<hr>';

// Test 4: Incluir config.php
echo '<h2>4. Incluir config.php</h2>';
try {
    include_once("api/config.php");
    echo '✓ config.php incluido correctamente<br>';
} catch (Exception $e) {
    echo '✗ Error al incluir config.php: ' . $e->getMessage() . '<br>';
    echo 'Archivo: ' . $e->getFile() . ':' . $e->getLine() . '<br>';
    die();
}
echo '<hr>';

// Test 5: Verificar DB
echo '<h2>5. Conexión Base de Datos</h2>';
try {
    if (isset($db) && $db != null) {
        echo '✓ Conexión BD: OK<br>';
        echo 'Database: ' . DB_NAME . '<br>';
    } else {
        echo '✗ Variable $db no definida<br>';
    }
} catch (Exception $e) {
    echo '✗ Error DB: ' . $e->getMessage() . '<br>';
}
echo '<hr>';

// Test 6: Clase Security
echo '<h2>6. Clase Security</h2>';
try {
    if (class_exists('Security')) {
        echo '✓ Clase Security: Existe<br>';
        $security = new Security(false);
        echo '✓ Security instanciada correctamente<br>';
    } else {
        echo '✗ Clase Security: NO existe<br>';
    }
} catch (Exception $e) {
    echo '✗ Error Security: ' . $e->getMessage() . '<br>';
    echo 'Archivo: ' . $e->getFile() . ':' . $e->getLine() . '<br>';
}
echo '<hr>';

// Test 7: ImageWorkshop
echo '<h2>7. ImageWorkshop (Test GdImage)</h2>';
try {
    if (class_exists('PHPImageWorkshop\ImageWorkshop')) {
        echo '✓ Clase ImageWorkshop: Existe<br>';
        
        // Test crear imagen
        $img = imagecreate(10, 10);
        $tipo = gettype($img);
        echo 'Tipo de imagen creada: <strong>' . $tipo . '</strong><br>';
        echo 'Es GdImage: ' . ($img instanceof \GdImage ? 'SÍ' : 'NO') . '<br>';
        echo 'Es resource: ' . (is_resource($img) ? 'SÍ' : 'NO') . '<br>';
        
        if ($img) imagedestroy($img);
    } else {
        echo '✗ Clase ImageWorkshop: NO existe<br>';
    }
} catch (Exception $e) {
    echo '✗ Error ImageWorkshop: ' . $e->getMessage() . '<br>';
    echo 'Archivo: ' . $e->getFile() . ':' . $e->getLine() . '<br>';
}
echo '<hr>';

echo '<h2>✅ Tests Completados</h2>';
echo '<p>Si todos los tests pasaron, el problema está en index.php o en las páginas internas.</p>';
echo '<p><strong>ELIMINAR ESTE ARCHIVO</strong> después de revisar.</p>';
?>
