<?php
namespace PHPImageWorkshop;

echo "Testing GD functions from namespace:\n\n";

// Test 1: con backslash
echo "1. Testing \\imagecreatefromjpeg: ";
if (function_exists('\\imagecreatefromjpeg')) {
    echo "EXISTS\n";
} else {
    echo "NOT FOUND\n";
}

// Test 2: intentar llamarla
echo "2. Attempting to call \\imagecreatefromjpeg: ";
try {
    $testImage = __DIR__ . '/publicidadpaneles/imagenElemento/test.jpg';
    if (file_exists($testImage)) {
        $img = \imagecreatefromjpeg($testImage);
        echo "SUCCESS\n";
        \imagedestroy($img);
    } else {
        echo "Test image not found\n";
    }
} catch (\Throwable $e) {
    echo "ERROR: " . $e->getMessage() . "\n";
}

// Test 3: verificar todas las funciones GD
echo "\n3. Available GD functions:\n";
$functions = get_defined_functions()['internal'];
$gdFunctions = array_filter($functions, function($func) {
    return strpos($func, 'image') === 0;
});
echo "Found " . count($gdFunctions) . " image functions\n";
echo implode(", ", array_slice($gdFunctions, 0, 10)) . "...\n";
