<?php
// Simular el contexto exacto de handlerimagenelemento.php
use PHPImageWorkshop\ImageWorkshop as ImageWorkshop;

define("PATH", "publicidadpaneles/api/");
include "publicidadpaneles/api/config.php";

echo "Testing ImageWorkshop from handler context:\n\n";

$testFile = "publicidadpaneles/imagenElemento/test.jpg";

// Create a simple test image if it doesn't exist
if (!file_exists("publicidadpaneles/imagenElemento/")) {
    mkdir("publicidadpaneles/imagenElemento/", 0777, true);
}

// Create a simple 1x1 JPEG for testing
if (!file_exists($testFile)) {
    $img = imagecreate(1, 1);
    imagecolorallocate($img, 255, 255, 255);
    imagejpeg($img, $testFile);
    imagedestroy($img);
    echo "Created test image\n";
}

try {
    echo "Attempting to load image with ImageWorkshop::initFromPath()...\n";
    $layer = ImageWorkshop::initFromPath("publicidadpaneles/imagenElemento/test.jpg");
    echo "SUCCESS!\n";
    print_r($layer);
} catch (Exception $e) {
    echo "ERROR: " . $e->getMessage() . "\n";
    echo "Trace: " . $e->getTraceAsString() . "\n";
}
