<?php
// Script de verificación de extensión GD en PHP
echo "=== Verificación de Extensión GD ===" . PHP_EOL;
echo "Versión de PHP: " . phpversion() . PHP_EOL;
echo PHP_EOL;

if (extension_loaded('gd')) {
    echo "✓ Extensión GD: HABILITADA" . PHP_EOL;
    echo PHP_EOL;
    
    $gdInfo = gd_info();
    echo "Información de GD:" . PHP_EOL;
    foreach ($gdInfo as $key => $value) {
        echo "  - $key: " . (is_bool($value) ? ($value ? 'Sí' : 'No') : $value) . PHP_EOL;
    }
    
    echo PHP_EOL;
    echo "Funciones críticas disponibles:" . PHP_EOL;
    echo "  - imagecreatefromjpeg: " . (function_exists('imagecreatefromjpeg') ? '✓ SÍ' : '✗ NO') . PHP_EOL;
    echo "  - imagecreatefrompng: " . (function_exists('imagecreatefrompng') ? '✓ SÍ' : '✗ NO') . PHP_EOL;
    echo "  - imagecreatefromgif: " . (function_exists('imagecreatefromgif') ? '✓ SÍ' : '✗ NO') . PHP_EOL;
} else {
    echo "✗ Extensión GD: NO HABILITADA" . PHP_EOL;
    echo PHP_EOL;
    echo "SOLUCIÓN REQUERIDA: Habilitar extensión GD en php.ini" . PHP_EOL;
}

echo PHP_EOL;
echo "Archivo php.ini en uso: " . php_ini_loaded_file() . PHP_EOL;
?>
